#version 330
#extension GL_EXT_gpu_shader4 : enable
// Smurf Gum in Vanilla CreamMod01.fsh  by  sy2002

//https://www.shadertoy.com/view/3sjXWz
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/* Smurf Gum in Vanilla Cream - First Raymarching Experiment
   inspired by "Raymarching for Dummies" tutorial from "The Art of Code" (https://youtu.be/PGtv-dBi2wE)
   done by sy2002 on 24th of March 2019
*/

#define MAX_STEPS		200
#define	MAX_DIST		100.0
#define SURFACE_DIST	0.01

#define IS_FLOOR		1.0
#define IS_OBJECT		2.0

//in Raymarching, the distance function equals the scene description
//the first scalar represents the object type, the second the actual distance
vec2 GetDist(vec3 p)
{    
    //distance to sphere = distance to center of sphere minus radius
    //y-pos and radius vary over time in some sin/cos pattern
	vec4 sphere = vec4(0, 1.0, 6, 1.0);
    sphere.y += 1.0 * cos(iTime/2.0);
    sphere.w += abs(sin(iTime / 3.0));
    float dS = length(p - sphere.xyz) - sphere.w;
    
    //displace the body of the sphere according to the x-position and the time
    dS += 0.2 * sin(sin(iTime/3.0)*7.0*p.x) * cos(iTime);
    
    //distance to ground plane is just height of camera due to our simple scene
    float dP = p.y + 0.01 * sin(p.x * 5.0 + iTime);
    
	//the object that is closest, wins
    vec2 retval = vec2(0);
    if (dP < dS)
        retval.x = IS_FLOOR;
    else
        retval.x = IS_OBJECT;
    
    //mix the two distances with an intensity that depends on how close they are
    float k = 0.5;
    float h = clamp(0.5 + 0.5*(dP-dS)/k, 0.0, 1.0);
    retval.y = mix(dP, dS, h) - k*h*(1.0-h);
    
    return retval;
}

//return the distance to the first object that the ray hits
//the first scalar represents the object type, the second the actual distance
vec2 RayMarch(vec3 ro, vec3 rd)
{
    float dO = 0.0; //distance from origin
    vec2 retval = vec2(0);
    for (int i = 0; i < MAX_STEPS; i++)
    {
        vec3 p = ro + dO*rd;	//march the ray
        retval = GetDist(p);
        float dS = retval.y;	//minimum distance from surface relative to p
        dO += dS;				//it is safe to march at least the distance dS without intersecting
        
        //approached surface close enough OR reached "infinity"
		if (dS < SURFACE_DIST || dO > MAX_DIST)
            break;
    }
    
    retval.y = dO;				//retval.x is the detected object type
    return retval;
}

//this is still magic to me, note to self: learn more
vec3 GetNormal(vec3 p)
{
    float d = GetDist(p).y;
    vec2 e = vec2(0.01, 0);
    
    vec3 n = d - vec3 (
        GetDist(p - e.xyy).y,
        GetDist(p - e.yxy).y,
        GetDist(p - e.yyx).y
    );
    return normalize(n);
}

//simple diffuse light model: maximum intensity, when the light ray is perpendicular
//to the surface and zero intensity, when it is parallel: this is the dot product
//between the normalized normal vector of the surface and the light
float GetLight(vec3 p)
{
    vec3 lightPos = vec3(-0.9, 0.9, 1.9);
    //lightPos.xz += vec2(sin(iTime), cos(iTime)) * 2.0;
    vec3 l = normalize(lightPos - p);	//light vector
    vec3 n = GetNormal(p);				//perpendicular to surface
    
    //the dot product delivers a value between -1..1, we need 0..1, so clamp it
    float dif = clamp(dot(n, l), 0.0, 1.0);
        
    return dif;
}

void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    //normalized and aspect ratio corrected pixel coordinates from -1 to 1
    vec2 uv = (gl_FragCoord.xy - 0.5*iResolution.xy) / iResolution.y;

    vec3 col = vec3(0);
    
    //ro = ray origin = camera
    //rd = ray direction
    vec3 ro = vec3(0, 1, 0);
    vec3 rd = normalize(vec3(uv.x, uv.y, 1));
 
    //distance to the nearest object
    vec2 retval = RayMarch(ro, rd);
    float object = retval.x;
    float d = retval.y;
    
    if (d < MAX_DIST) //Vanilla Cream + Smurf Gum
    {
        //light that point using diffuse lighting
        vec3 p = ro + rd*d;
        float dif = GetLight(p);
        if (object == IS_FLOOR)
            col = vec3(0.92, 0.92, 0.65) * vec3(dif) * 1.1 + 0.1;
        else
        	col = vec3(0.0, 0.7, 1.0) * vec3(dif) * 1.2 + vec3(0.05, 0.05, 0.2);
    }
    else //sky
    {
        const vec3 left  = vec3(0.698, 0.996, 0.980);
        const vec3 right = vec3(0.055, 0.824, 0.969);
        col = mix(left, right, (gl_FragCoord.x / iResolution.x) * (gl_FragCoord.y / (0.4*iResolution.y))) - 0.05; 
    }
    
    //output to screen
    gl_FragColor = vec4(col, 1.0);
}